function  plot_CDF(fDefs,error)

%load('error.mat')
% Variables
lineWidth = 2;
maxError = 35;

    
% Positioning with average1
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fig = figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off'); 
    
    % Set 1 Telf 1
    h = cdfplot(error.set(1).telf(1).average1.errors); 
    set(h, 'LineStyle', '--', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(1).telf(2).average1.errors); 
    set(h, 'LineStyle', '--', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(1).telf(3).average1.errors); 
    set(h, 'LineStyle', '--', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 1
    h = cdfplot(error.set(2).telf(1).average1.errors); 
    set(h, 'LineStyle', ':', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(2).telf(2).average1.errors); 
    set(h, 'LineStyle', ':', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(2).telf(3).average1.errors); 
    set(h, 'LineStyle', ':', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 1
    h = cdfplot(error.set(3).telf(1).average1.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 2
    h = cdfplot(error.set(3).telf(2).average1.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    
    legend({'Set 1 - Bq' , 'Set 1 - S6','Set 1 - Mi 8','Set 2 - Bq' , 'Set 2 - S6','Set 2 - Mi 8','Set 3 - Bq' , 'Set 3 - S6'},'Location','southeast','FontSize',3,'FontName', 'Times New Roman');
    
    grid on
    xlabel("Error (m)",'FontSize',10,'FontName', 'Times New Roman')
    ylabel("CDF",'FontSize',10,'FontName', 'Times New Roman')
    title(strcat(' '));
    box on
    daspect([17.5, 1, 1])
    xlim([0 maxError])
    
    hold off
    fig1.Renderer = 'Painters'
    old_sdf('Fer_BoldStyle_NoExpandAxex');
    print(fig,strcat('figures/CDF_positioning_average1.pdf'),'-dpdf');
    
    
    
% Positioning with average2
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fig = figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off'); 
    
    % Set 1 Telf 1
    h = cdfplot(error.set(1).telf(1).average2.errors); 
    set(h, 'LineStyle', '--', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(1).telf(2).average2.errors); 
    set(h, 'LineStyle', '--', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(1).telf(3).average2.errors); 
    set(h, 'LineStyle', '--', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 1
    h = cdfplot(error.set(2).telf(1).average2.errors); 
    set(h, 'LineStyle', ':', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(2).telf(2).average2.errors); 
    set(h, 'LineStyle', ':', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(2).telf(3).average2.errors); 
    set(h, 'LineStyle', ':', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 1
    h = cdfplot(error.set(3).telf(1).average2.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 2
    h = cdfplot(error.set(3).telf(2).average2.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    
    legend({'Set 1 - Bq' , 'Set 1 - S6','Set 1 - Mi 8','Set 2 - Bq' , 'Set 2 - S6','Set 2 - Mi 8','Set 3 - Bq' , 'Set 3 - S6'},'Location','southeast','FontSize',3,'FontName', 'Times New Roman');
    grid on
    xlabel("Error (m)",'FontSize',10,'FontName', 'Times New Roman')
    ylabel("CDF",'FontSize',10,'FontName', 'Times New Roman')
    title(strcat(' '));
    box on
    daspect([17.5, 1, 1])
    xlim([0 maxError])
    
    hold off
    fig1.Renderer = 'Painters'
    old_sdf('Fer_BoldStyle_NoExpandAxex');
    print(fig,strcat('figures/CDF_positioning_average2.pdf'),'-dpdf');

    
% Positioning with average3
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fig = figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off'); 
    
    % Set 1 Telf 1
    h = cdfplot(error.set(1).telf(1).average3.errors); 
    set(h, 'LineStyle', '--', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(1).telf(2).average3.errors); 
    set(h, 'LineStyle', '--', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(1).telf(3).average3.errors); 
    set(h, 'LineStyle', '--', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 1
    h = cdfplot(error.set(2).telf(1).average3.errors); 
    set(h, 'LineStyle', ':', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(2).telf(2).average3.errors); 
    set(h, 'LineStyle', ':', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(2).telf(3).average3.errors); 
    set(h, 'LineStyle', ':', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 1
    h = cdfplot(error.set(3).telf(1).average3.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 2
    h = cdfplot(error.set(3).telf(2).average3.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    
   legend({'Set 1 - Bq' , 'Set 1 - S6','Set 1 - Mi 8','Set 2 - Bq' , 'Set 2 - S6','Set 2 - Mi 8','Set 3 - Bq' , 'Set 3 - S6'},'Location','southeast','FontSize',3,'FontName', 'Times New Roman');
    grid on
    xlabel("Error (m)",'FontSize',10,'FontName', 'Times New Roman')
    ylabel("CDF",'FontSize',10,'FontName', 'Times New Roman')
    title(strcat(' '));
    box on
    daspect([17.5, 1, 1])
    xlim([0 maxError])
    
    hold off
    fig1.Renderer = 'Painters'
    old_sdf('Fer_BoldStyle_NoExpandAxex');
    print(fig,strcat('figures/CDF_positioning_average3.pdf'),'-dpdf');
    
    
    
% Positioning with average4
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fig = figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off'); 
    
    % Set 1 Telf 1
    h = cdfplot(error.set(1).telf(1).average4.errors); 
    set(h, 'LineStyle', '--', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(1).telf(2).average4.errors); 
    set(h, 'LineStyle', '--', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(1).telf(3).average4.errors); 
    set(h, 'LineStyle', '--', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 1
    h = cdfplot(error.set(2).telf(1).average4.errors); 
    set(h, 'LineStyle', ':', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(2).telf(2).average4.errors); 
    set(h, 'LineStyle', ':', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(2).telf(3).average4.errors); 
    set(h, 'LineStyle', ':', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 1
    h = cdfplot(error.set(3).telf(1).average4.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 2
    h = cdfplot(error.set(3).telf(2).average4.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    
    legend({'Set 1 - Bq' , 'Set 1 - S6','Set 1 - Mi 8','Set 2 - Bq' , 'Set 2 - S6','Set 2 - Mi 8','Set 3 - Bq' , 'Set 3 - S6'},'Location','southeast','FontSize',3,'FontName', 'Times New Roman');
    grid on
    xlabel("Error (m)",'FontSize',10,'FontName', 'Times New Roman')
    ylabel("CDF",'FontSize',10,'FontName', 'Times New Roman')
    title(strcat(' '));
    box on
    daspect([17.5, 1, 1])
    xlim([0 maxError])
    
    hold off
    fig1.Renderer = 'Painters'
    old_sdf('Fer_BoldStyle_NoExpandAxex');
    print(fig,strcat('figures/CDF_positioning_average4.pdf'),'-dpdf');



    hold off
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % Positioning with all 180 beacons
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fig = figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off'); 
    
    % Set 1 Telf 1
    h = cdfplot(error.set(1).telf(1).all.errors); 
    set(h, 'LineStyle', '--', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(1).telf(2).all.errors); 
    set(h, 'LineStyle', '--', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(1).telf(3).all.errors); 
    set(h, 'LineStyle', '--', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 1
    h = cdfplot(error.set(2).telf(1).all.errors); 
    set(h, 'LineStyle', ':', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(2).telf(2).all.errors); 
    set(h, 'LineStyle', ':', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(2).telf(3).all.errors); 
    set(h, 'LineStyle', ':', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 1
    h = cdfplot(error.set(3).telf(1).all.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 2
    h = cdfplot(error.set(3).telf(2).all.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    
    legend({'Set 1 - Bq' , 'Set 1 - S6','Set 1 - Mi 8','Set 2 - Bq' , 'Set 2 - S6','Set 2 - Mi 8','Set 3 - Bq' , 'Set 3 - S6'},'Location','southeast','FontSize',3,'FontName', 'Times New Roman');
    grid on
    xlabel("Error (m)",'FontSize',10,'FontName', 'Times New Roman')
    ylabel("CDF",'FontSize',10,'FontName', 'Times New Roman')
    title(strcat(' '));
    box on
    daspect([17.5, 1, 1])
    xlim([0 maxError])
    
    hold off
    fig1.Renderer = 'Painters'
    old_sdf('Fer_BoldStyle_NoExpandAxex');
    print(fig,strcat('figures/CDF_positioning_180.pdf'),'-dpdf');
    hold off
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    % Positioning with single slot (first)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    fig = figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off'); 
    
    % Set 1 Telf 1
    h = cdfplot(error.set(1).telf(1).slot.errors); 
    set(h, 'LineStyle', '--', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(1).telf(2).slot.errors); 
    set(h, 'LineStyle', '--', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(1).telf(3).slot.errors); 
    set(h, 'LineStyle', '--', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 1
    h = cdfplot(error.set(2).telf(1).slot.errors); 
    set(h, 'LineStyle', ':', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 2
    h = cdfplot(error.set(2).telf(2).slot.errors); 
    set(h, 'LineStyle', ':', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    % Set 1 Telf 3
    h = cdfplot(error.set(2).telf(3).slot.errors); 
    set(h, 'LineStyle', ':', 'Color', 'g', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 1
    h = cdfplot(error.set(3).telf(1).slot.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'b', 'LineWidth', lineWidth);
    hold on
    
    % Set 3 Telf 2
    h = cdfplot(error.set(3).telf(2).slot.errors); 
    set(h, 'LineStyle', '-.', 'Color', 'r', 'LineWidth', lineWidth);
    hold on
    
    
   legend({'Set 1 - Bq' , 'Set 1 - S6','Set 1 - Mi 8','Set 2 - Bq' , 'Set 2 - S6','Set 2 - Mi 8','Set 3 - Bq' , 'Set 3 - S6'},'Location','southeast','FontSize',3,'FontName', 'Times New Roman');
    grid on
    title(strcat('  '));
    xlabel("Error (m)",'FontSize',10,'FontName', 'Times New Roman')
    ylabel("CDF",'FontSize',10,'FontName', 'Times New Roman')
    box on
    daspect([17.5, 1, 1])
    xlim([0 maxError])
    
    hold off
    fig1.Renderer = 'Painters'
    old_sdf('Fer_BoldStyle_NoExpandAxex');
    print(fig,strcat('figures/CDF_positioning_first_slot.pdf'),'-dpdf');
    hold off
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    % Table - slot 1
    % Deployment variables
    media = zeros(1,3*3);
    mediana = zeros(1,3*3);
    percentil95 = zeros(1,3*3);
    aciertoZ = zeros(1,3*3);
    aciertoTag = zeros(1,3*3);
   
    
    dumbIndex = 1;
    
    for i=1:1:3
        for j=1:1:length(fDefs.set(i).phones)
            media(dumbIndex) = mean(error.set(i).telf(j).slot.errors);
            mediana(dumbIndex) = median(error.set(i).telf(j).slot.errors);
            percentil95(dumbIndex) = prctile(error.set(i).telf(j).slot.errors,95);
            aciertoZ(dumbIndex) = error.set(i).telf(j).slot.floor;
            aciertoTag(dumbIndex) = error.set(i).telf(j).slot.zone;
            dumbIndex = dumbIndex +1;
        end
    end
    
    media(9) = mean(media(1:8));
    mediana(9) = mean(mediana(1:8));
    percentil95(9) = mean(percentil95(1:8));
    aciertoZ(9) = mean(aciertoZ(1:8));
    aciertoTag(9) = mean(aciertoTag(1:8));
    
    
    
    % Meditar
    varNames = {'Mean','Median','Percentile','Floorclc','TagId'};
    rowNames = {'Set 1 - Telf 1';'Set 1 - Telf 2';'Set 1 - Telf 3';'Set 2 - Telf 1';'Set 2 - Telf 2';'Set 2 - Telf 3';'Set 3 - Telf 1';'Set 3 - Telf 2'; 'Average'};
    %allData = [media';mediana';percentil95;aciertoZ];
    T = table(media' ,mediana',percentil95',aciertoZ',aciertoTag','VariableNames',varNames, 'RowNames',rowNames);
    disp("slot")
    disp(slot);
    disp(T);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    % Table - Average
    % Deployment variables
    media = zeros(1,3*3);
    mediana = zeros(1,3*3);
    percentil95 = zeros(1,3*3);
    aciertoZ = zeros(1,3*3);
    aciertoTag = zeros(1,3*3);
    dumbIndex = 1;
    
    for i=1:1:3
        
        for j=1:1:length(fDefs.set(i).phones)
            media(dumbIndex) = mean(error.set(i).telf(j).average1.errors);
            mediana(dumbIndex) = median(error.set(i).telf(j).average1.errors);
            percentil95(dumbIndex) = prctile(error.set(i).telf(j).average1.errors,95);
            aciertoZ(dumbIndex) = error.set(i).telf(j).average1.floor;
            aciertoTag(dumbIndex) = error.set(i).telf(j).average1.zone;
            
            dumbIndex = dumbIndex +1;
        end
    end
    
        media(9) = mean(media(1:8));
    mediana(9) = mean(mediana(1:8));
    percentil95(9) = mean(percentil95(1:8));
    aciertoZ(9) = mean(aciertoZ(1:8));
    aciertoTag(9) = mean(aciertoTag(1:8));
    
    % Meditar
    varNames = {'Mean','Median','Percentile','Floorclc','TagId'};
    rowNames = {'Set 1 - Telf 1';'Set 1 - Telf 2';'Set 1 - Telf 3';'Set 2 - Telf 1';'Set 2 - Telf 2';'Set 2 - Telf 3';'Set 3 - Telf 1';'Set 3 - Telf 2'; 'Average'};
    %allData = [media';mediana';percentil95;aciertoZ];
    T = table(media' ,mediana',percentil95',aciertoZ',aciertoTag','VariableNames',varNames, 'RowNames',rowNames);
    disp("Average1")
    disp(T);
    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    % Table - Average
    % Deployment variables
    media = zeros(1,3*3);
    mediana = zeros(1,3*3);
    percentil95 = zeros(1,3*3);
    aciertoZ = zeros(1,3*3);
    aciertoTag = zeros(1,3*3);
    dumbIndex = 1;
    
    for i=1:1:3
        
        for j=1:1:length(fDefs.set(i).phones)
            media(dumbIndex) = mean(error.set(i).telf(j).average2.errors);
            mediana(dumbIndex) = median(error.set(i).telf(j).average2.errors);
            percentil95(dumbIndex) = prctile(error.set(i).telf(j).average2.errors,95);
            aciertoZ(dumbIndex) = error.set(i).telf(j).average2.floor;
            aciertoTag(dumbIndex) = error.set(i).telf(j).average2.zone;
            
            dumbIndex = dumbIndex +1;
        end
    end
    
        media(9) = mean(media(1:8));
    mediana(9) = mean(mediana(1:8));
    percentil95(9) = mean(percentil95(1:8));
    aciertoZ(9) = mean(aciertoZ(1:8));
    aciertoTag(9) = mean(aciertoTag(1:8));
    
    % Meditar
    varNames = {'Mean','Median','Percentile','Floorclc','TagId'};
    rowNames = {'Set 1 - Telf 1';'Set 1 - Telf 2';'Set 1 - Telf 3';'Set 2 - Telf 1';'Set 2 - Telf 2';'Set 2 - Telf 3';'Set 3 - Telf 1';'Set 3 - Telf 2'; 'Average'};
    %allData = [media';mediana';percentil95;aciertoZ];
    T = table(media' ,mediana',percentil95',aciertoZ',aciertoTag','VariableNames',varNames, 'RowNames',rowNames);
    disp("Average2")
    disp(T);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    % Table - Average
    % Deployment variables
    media = zeros(1,3*3);
    mediana = zeros(1,3*3);
    percentil95 = zeros(1,3*3);
    aciertoZ = zeros(1,3*3);
    aciertoTag = zeros(1,3*3);
    dumbIndex = 1;
    
    for i=1:1:3
        
        for j=1:1:length(fDefs.set(i).phones)
            media(dumbIndex) = mean(error.set(i).telf(j).average3.errors);
            mediana(dumbIndex) = median(error.set(i).telf(j).average3.errors);
            percentil95(dumbIndex) = prctile(error.set(i).telf(j).average3.errors,95);
            aciertoZ(dumbIndex) = error.set(i).telf(j).average3.floor;
            aciertoTag(dumbIndex) = error.set(i).telf(j).average3.zone;
            
            dumbIndex = dumbIndex +1;
        end
    end
    
        media(9) = mean(media(1:8));
    mediana(9) = mean(mediana(1:8));
    percentil95(9) = mean(percentil95(1:8));
    aciertoZ(9) = mean(aciertoZ(1:8));
    aciertoTag(9) = mean(aciertoTag(1:8));
    
    % Meditar
    varNames = {'Mean','Median','Percentile','Floorclc','TagId'};
    rowNames = {'Set 1 - Telf 1';'Set 1 - Telf 2';'Set 1 - Telf 3';'Set 2 - Telf 1';'Set 2 - Telf 2';'Set 2 - Telf 3';'Set 3 - Telf 1';'Set 3 - Telf 2'; 'Average'};
    %allData = [media';mediana';percentil95;aciertoZ];
    T = table(media' ,mediana',percentil95',aciertoZ',aciertoTag','VariableNames',varNames, 'RowNames',rowNames);
    disp("Average3")
    disp(T);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    % Table - Average
    % Deployment variables
    media = zeros(1,3*3);
    mediana = zeros(1,3*3);
    percentil95 = zeros(1,3*3);
    aciertoZ = zeros(1,3*3);
    aciertoTag = zeros(1,3*3);
    dumbIndex = 1;
    
    for i=1:1:3
        
        for j=1:1:length(fDefs.set(i).phones)
            media(dumbIndex) = mean(error.set(i).telf(j).average4.errors);
            mediana(dumbIndex) = median(error.set(i).telf(j).average4.errors);
            percentil95(dumbIndex) = prctile(error.set(i).telf(j).average4.errors,95);
            aciertoZ(dumbIndex) = error.set(i).telf(j).average4.floor;
            aciertoTag(dumbIndex) = error.set(i).telf(j).average4.zone;
            
            dumbIndex = dumbIndex +1;
        end
    end
    
        media(9) = mean(media(1:8));
    mediana(9) = mean(mediana(1:8));
    percentil95(9) = mean(percentil95(1:8));
    aciertoZ(9) = mean(aciertoZ(1:8));
    aciertoTag(9) = mean(aciertoTag(1:8));
    
    % Meditar
    varNames = {'Mean','Median','Percentile','Floorclc','TagId'};
    rowNames = {'Set 1 - Telf 1';'Set 1 - Telf 2';'Set 1 - Telf 3';'Set 2 - Telf 1';'Set 2 - Telf 2';'Set 2 - Telf 3';'Set 3 - Telf 1';'Set 3 - Telf 2'; 'Average'};
    %allData = [media';mediana';percentil95;aciertoZ];
    T = table(media' ,mediana',percentil95',aciertoZ',aciertoTag','VariableNames',varNames, 'RowNames',rowNames);
    disp("Average4")
    disp(T);
   
   
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    % Table - all
    % Deployment variables
    media = zeros(1,3*3-1);
    mediana = zeros(1,3*3-1);
    percentil95 = zeros(1,3*3-1);
    aciertoZ = zeros(1,3*3-1);
    dumbIndex = 1;
    aciertoTag = zeros(1,3*3-1);
    
    for i=1:1:3
        for j=1:1:length(fDefs.set(i).phones)
            media(dumbIndex) = mean(error.set(i).telf(j).all.errors);
            mediana(dumbIndex) = median(error.set(i).telf(j).all.errors);
            percentil95(dumbIndex) = prctile(error.set(i).telf(j).all.errors,95);
            aciertoZ(dumbIndex) = error.set(i).telf(j).all.floor;
            aciertoTag(dumbIndex) = error.set(i).telf(j).all.zone;
            dumbIndex = dumbIndex +1;
        end
    end
    
        media(9) = mean(media(1:8));
    mediana(9) = mean(mediana(1:8));
    percentil95(9) = mean(percentil95(1:8));
    aciertoZ(9) = mean(aciertoZ(1:8));
    aciertoTag(9) = mean(aciertoTag(1:8));
    
    % Meditar
    varNames = {'Mean','Median','Percentile','Floorclc','TagId'};
    rowNames = {'Set 1 - Telf 1';'Set 1 - Telf 2';'Set 1 - Telf 3';'Set 2 - Telf 1';'Set 2 - Telf 2';'Set 2 - Telf 3';'Set 3 - Telf 1';'Set 3 - Telf 2'; 'Average'};
    %allData = [media';mediana';percentil95;aciertoZ];
    T = table(media' ,mediana',percentil95',aciertoZ',aciertoTag','VariableNames',varNames, 'RowNames',rowNames);
    disp("all")
    disp(T);

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 

end